﻿namespace WindowsLiveId
{
    using System;

    public interface IWindowsLiveLogin
    {
        string AppId { get; set; }
        string AppUrl { get; set; }
        string BaseUrl { get; set; }
        string ConsentUrl { get; set; }
        string OldSecret { get; set; }
        string OldSecretExpiry { get; set; }
        string PolicyUrl { get; set; }
        string ReturnUrl { get; set; }
        string Secret { get; set; }
        string SecureUrl { get; set; }
        string SecurityAlgorithm { get; set; }
        bool ForceDelAuthNonProvisioned { get; set; }

        string DecodeAndValidateToken(string token);
        string DecodeAndValidateToken(string token, byte[] cryptKey, byte[] signKey);
        string DecodeToken(string token);
        string DecodeToken(string token, byte[] cryptKey);
        string GetAppLoginUrl();
        string GetAppLoginUrl(string siteId);
        string GetAppLoginUrl(string siteId, string ip);
        string GetAppLoginUrl(string siteId, string ip, bool js);
        string GetAppRetCode();
        string GetAppSecurityToken();
        string GetAppSecurityToken(string siteId);
        string GetAppSecurityToken(string siteId, string ip);
        string GetAppVerifier();
        string GetAppVerifier(string ip);
        void GetClearCookieResponse(out string type, out byte[] content);
        string GetConsentUrl(string offers);
        string GetConsentUrl(string offers, string context);
        string GetConsentUrl(string offers, string context, string ru);
        string GetConsentUrl(string offers, string context, string ru, string market);
        string GetLoginUrl();
        string GetLoginUrl(string context);
        string GetLoginUrl(string context, string market);
        string GetLogoutUrl();
        string GetLogoutUrl(string market);
        string GetManageConsentUrl();
        string GetManageConsentUrl(string market);
        string GetMobileLoginUrl();
        string GetMobileLoginUrl(string context);
        string GetMobileLoginUrl(string context, string market);
        string GetRefreshConsentTokenUrl(string offers, string refreshToken);
        string GetRefreshConsentTokenUrl(string offers, string refreshToken, string ru);
        string GetTrustedLoginUrl();
        string GetTrustedLogoutUrl();
        System.Collections.Specialized.NameValueCollection GetTrustedParams(string user);
        System.Collections.Specialized.NameValueCollection GetTrustedParams(string user, string retcode);
        string GetTrustedToken(string user);
        WindowsLiveLogin.ConsentToken ProcessConsent(System.Collections.Specialized.NameValueCollection query);
        WindowsLiveLogin.ConsentToken ProcessConsentToken(string token);
        WindowsLiveLogin.ConsentToken ProcessConsentToken(string token, string context);
        WindowsLiveLogin.User ProcessLogin(System.Collections.Specialized.NameValueCollection query);
        WindowsLiveLogin.User ProcessToken(string token);
        WindowsLiveLogin.User ProcessToken(string token, string context);
        WindowsLiveLogin.ConsentToken RefreshConsentToken(string offers, string refreshToken);
        WindowsLiveLogin.ConsentToken RefreshConsentToken(string offers, string refreshToken, string ru);
        WindowsLiveLogin.ConsentToken RefreshConsentToken(WindowsLiveLogin.ConsentToken token);
        WindowsLiveLogin.ConsentToken RefreshConsentToken(WindowsLiveLogin.ConsentToken token, string ru);
        byte[] SignToken(string token);
        byte[] SignToken(string token, byte[] signKey);
        string ValidateToken(string token);
        string ValidateToken(string token, byte[] signKey);
    }
}
